;; CREDITS:
;; -----------------------------------------------------------
;; Script written by (, 2000) sYx66.
;; http://i.am/syx
;; Thanks to [UTG]LOKi for the DLL!
;; http://argus.splatterworld.de
;; Feel free to edit, give credit to sYx66 & LOKi.

;; USE:
;; -----------------------------------------------------------
;; 1) Simply right click on a channel and click Add, then click Start.
;; Go in Q3 and type something like this: \irc #channel <message>
;; After you type #channel once you don't have to type it again, only
;; if you want to send <message> to another channel.

;; 2) You can send commands to irc using \irc /mIRC_Command
;; Make sure to start your command with a / character.

;; 3) You can use these commands to quickly have control over QIRC:
;; \irc /qirc_end                -stops QIRC all the way
;; \irc /qirc_add #channel       -add #channel (might need to \irc /join #channel)
;; \irc /qirc_rem #channel       -remove #channel (don't see it's text/actions)


;; -----------------------------------------------------------
;; popups

menu channel,query,menubar,status {
  QIRC
  .QIRC
  ..Start  : qirc.s
  ..End    : qirc_end 2
  .Current Channel
  ..Add    : qirc_add $chan 1
  ..Remove : qirc_rem $chan 1
  .All The Channels
  ..Print  : qirc.q qirc_c.txt 0
  ..Clear  : {
    if ($?!="Clear all channels from list?" == $true) { 
      write -c qirc_c.txt 
      echo -a 1,15 + QIRC 11,01 All channels were cleared 
    }
  }
  .Delay Timer  : {
    var %qirc.v.c = $?="Delay between Q3 console check: $crlf $+ Range: 100 - 10,000 milliseconds"
    if (%qirc.v.c isnum 100-10000) { 
      .writeini qirc_o.txt Options timer %qirc.v.c
      echo -a 1,15 + QIRC 11,01 Timer delay set to8 %qirc.v.c 
    }
  }
}

;; add channel

alias qirc_add {
  if ($1 == $null) { halt }
  var %qirc.v.d = $lower($1)
  var %qirc.v.c = $qirc.q(qirc_c.txt,%qirc.v.d)
  if (%qirc.v.c > 0) { 
    if ($2 != 1) { qirc.f.s 0 ^6*** ^1Error: Channel already exists }
    echo -a 1,15 + QIRC 08,01 Channel9 %qirc.v.d 8already exists 
  }
  else { 
    write qirc_c.txt %qirc.v.d 
    if (%qirc2 == $null) { set %qirc2 %qirc.v.d }
    if ($2 != 1) { qirc.f.s 0 ^6*** ^1QIRC: Channel ^2 $+ %qirc.v.d added }
    echo -a 1,15 + QIRC 08,01 Channel9 %qirc.v.d 8added 
  }
}

;; remove channel

alias qirc_rem {
  if ($1 == $null) { halt }
  var %qirc.v.d = $lower($1)
  var %qirc.v.c = $qirc.q(qirc_c.txt,%qirc.v.d)
  if (%qirc.v.c > 0) {
    write -dl $+ %qirc.v.c qirc_c.txt 
    if ($2 != 1) { qirc.f.s 0 ^6*** ^1QIRC: Channel ^2 $+ %qirc.v.d removed }
    echo -a 1,15 + QIRC 08,01 Channel9 %qirc.v.d 8removed 
  }
  else { 
    if ($2 != 1) { qirc.f.s 0 ^6*** ^1Error: Channel doesn't exist in the list }
    echo -a 1,15 + QIRC 08,01 Channel9 %qirc.v.d 8doesn't exist in the list  
  }
}

;; go through file and find match, return line # if match found, else 0
;; added function to print all entries to active channel

alias -l qirc.q {
  var %file.c = $lines($1)
  var %file.t = 0
  :again
  if (%file.c > 0) {
    %file.t = $read -l $+ %file.c $1
    %file.t = $lower(%file.t)
    if ($2 == 0) { 
      var %qirc.p = 1
      echo -a 1,15 + QIRC 08,01 $str(0,$calc(4-$len(%file.c))) $+ %file.c 09 $+ %file.t  
    }
    else if (%file.t == $2) { 
      return %file.c 
      unset %file.*
      halt 
    }
    dec %file.c
    goto again
  }
  if (%qirc.p != 1 && $2 == 0) { echo -a 1,15 + QIRC 08,01 There are no channels to print  }
  return 0
}

;; send text to console if came from channel in list, or is 0

alias -l qirc.f.s {
  if ($exists(qirc.dll) == $false) { halt }
  if ($1 == 0 || $qirc.q(qirc_c.txt,$1) > 0) {
    .dll qirc.dll SendConsole echo $remove($2-, \irc,;) 
  }
}

;; scan q3 console and parse the messages

alias -l qirc.f.c {
  if ($exists(qirc.dll) == $null) { halt }
  var %qirc.v.g = $dll(qirc.dll,ScanConsole,\irc)
  .dll qirc.dll ClearConsole
  if (%qirc.v.g == $null) { halt }
  var %qirc.v.i = 1
  :again
  var %qirc.v.t = $gettok(%qirc.v.g,%qirc.v.i,255)
  if (%qirc.v.t != $null) {
    if ($left(%qirc.v.t,1) == $chr(35)) {
      var %qirc.v.k = $gettok(%qirc.v.t,1,32)
      var %qirc.v.u = $gettok(%qirc.v.t,2-,32)      
      set %qirc2 %qirc.v.k
      .writeini qirc_o.txt Options chan %qirc2
      if (%qirc.v.u != $null) { msg %qirc.v.k %qirc.v.u }
    }
    else if ($left(%qirc.v.t,1) == $chr(47)) { %qirc.v.t }
    else { 
      if (%qirc2 == $null) {
        .dll qirc.dll SendConsole echo ^6*** ^1Error: \irc $chr(35) $+ chan msg, You need to do this only once. 
      }
      else { msg %qirc2 %qirc.v.t }
    }
  }
  if (%qirc.v.i < $numtok(%qirc.v.g,255)) { 
    inc %qirc.v.i 
    goto again 
  }
}

;; start script

alias -l qirc.s { 
  if ($exists(qirc.dll) == $false) { echo -a 1,15 + QIRC 11,01 *** Error: 8qirc.dll11 not found!  | halt }
  qirc_end 1
  var %qirc.v.g $readini qirc_o.txt Options chan
  if (%qirc.v.g != $null) { set %qirc2 %qirc.v.g }
  else if (%qirc2 == $null) { set %qirc2 $read -l1 qirc_c.txt }
  var %qirc.v.c = $readini qirc_o.txt Options timer 
  if (%qirc.v.c !isnum 100-10000) { %qirc.v.c = 1200 }
  .timerQIRC -m 0 %qirc.v.c qirc.f.c
  .dll qirc.dll SendConsole seta "irc" "wait"
  .dll qirc.dll ClearConsole
  .enable #Events
  echo -a 1,15 + QIRC 11,01 QIRC started 
}

;; end script

alias qirc_end {
  unset %qirc2
  .timerQIRC off
  .disable #Events
  if ($1 != 1) {
    if ($1 != 2) { qirc.f.s 0 ^6*** ^1QIRC: Shutting down }
    echo -a 1,15 + QIRC 11,01 QIRC ended  
  }
}

;; event triggers

#Events on
on *:TEXT:*:#: qirc.f.s $lower($chan) ^2 $+ $lower($chan) ^5<^7 $+ $nick $+ ^5>^3 $1- 
on *:TEXT:*:?: qirc.f.s 0 ^1<^7 $+ $nick $+ ^1>^3 $1- 
on *:JOIN:*: qirc.f.s $lower($chan) ^6*** $nick joins ^2 $+ $lower($chan)
on *:QUIT: qirc.f.s 0 ^6*** $nick quit IRC ( $+ $1- $+ )
on *:PART:*: qirc.f.s $lower($chan) ^6*** $nick left ^2 $+ $lower($chan)
on *:NICK: qirc.f.s 0 ^6*** $nick changed nickname to $newnick
on *:TOPIC:*: qirc.f.s $lower($chan) ^6*** $nick changed ^2 $+ $lower($chan) topic to $1-
on *:ERROR:*: qirc.f.s 0 ^6*** ^1Error: $1-
#Events end
